<?= $this->extend('layouts/main') ?>

<?= $this->section('content') ?>

    <div class="d-flex justify-content-center" id="loader" style="display:none !important">
        <div class="spinner-border" role="status">
            <span class="visually-hidden">Loading...</span>
        </div>
    </div>

    <div id="seccio-opt">
        <div class="container pt-5 pb-5" id="web-section" v-if="isHiddenFinal">
            <div class="row">
                <div class="col-md-8 container-box-c">
                    <div id="cost-sections">
                        <form method="post" action="<?= base_url().'/home/resum' ?>">
                            <?php foreach($opcions as $opcio): $x = 0; ?>
                            <div class="section-option" id="option-wrap-<?= $opcio->id_opcio ?>">
                                <h3 class="title-cost"><?= $opcio->nom_opcio ?></h3>
                                <p class="subtitle-cost">
                                    <?= $opcio->desc_opcio ?>
                                </p>
                                <div class="options-c">
                                    <?php
                                    $mods = get_mods($opcio->id_opcio);
                                    $long = '';
                                    if(count($mods) <= 3){
                                        $cols = '3';
                                    }
                                    elseif(count($mods) <= 5){
                                        $cols = count($mods);
                                    }
                                    elseif(count($mods) >= 6){
                                        $cols = 'auto';
                                        $long = 'options-radio-inline-long';
                                    }else{
                                        $cols = '5';
                                    }
                                    ?>
                                    <div class="options-radio-inline <?= $long ?>">
                                        <?php if($opcio->tipus_opcio != 2): ?>
                                        <div class="row row-cols-<?= $cols ?>">
                                            <?php foreach($mods as $mod): ?>
                                            <div class="col">
                                                <div class="form-radio-option">
                                                    <label class="form-check-label <?= ($opcio->img_opcio)?'label-img-mod':''; ?>"><!-- active-opt -->
                                                        <?php if($opcio->img_opcio): ?>
                                                            <div class="img-wrap-mod">
                                                            <?php if($opcio->url_opcio) echo '<a href="'.$mod->url_mod.'" target="_blank" class="external-link-mod"><span><i class="material-icons">link</i>Exemple</span></a>'; ?>
                                                            <img src="<?= ($mod->img_mod)?base_url().$mod->img_mod:base_url().'/dist/img/no-image.png'; ?>" class="img-mod">
                                                            </div>
                                                        <?php endif; ?>
                                                        <div class="title-option">
                                                            <span><?= $mod->nom_mod ?></span>
                                                            <?php
                                                            $tipus = 'radio';
                                                            $name = 'opcio-'.$opcio->id_opcio;
                                                            if($opcio->tipus_opcio == 1){
                                                                $tipus = 'checkbox';
                                                                $name = 'opcioItem[]';
                                                            }
                                                            ?>
                                                            <input class="form-check-input" name="<?= $name ?>" type="<?= $tipus ?>" data-wrap="#option-wrap-<?= $opcio->id_opcio ?>" data-price="<?= $mod->preu_mod ?>" data-name="<?= $mod->nom_mod ?>" data-type="<?= $opcio->nom_opcio ?>" data-id="<?= $opcio->id_opcio ?>" data-mod="<?= $mod->id_mod ?>" value="<?= $mod->id_mod ?>">
                                                        </div>
                                                        <?php if($mod->desc_mod): ?>
                                                        <small><?= $mod->desc_mod ?></small>
                                                        <?php endif; ?>
                                                    </label>
                                                </div>
                                            </div>
                                            <?php endforeach; ?>
                                        </div>
                                        <?php else: ?>
                                        <div class="range-c">
                                            <div class="row">
                                                <div class="col-10">
                                                    <input type="range" class="form-range form-range-input" id="range-c-input-<?= $mods[0]->id_mod ?>" min="<?= $mods[0]->min_mod ?>" max="<?= $mods[0]->max_mod ?>" step="1" value="<?= $mods[0]->min_mod ?>" name="opcionsRange[<?= $mods[0]->id_mod ?>][]" data-item="#range-c-input-val-<?= $mods[0]->id_mod ?>">
                                                </div>
                                                <div class="col-2">
                                                    <span>
                                                        <b><span id="range-c-input-val-<?= $mods[0]->id_mod ?>"><?= $mods[0]->min_mod ?></span> <?= $mods[0]->nom_mod ?></b>
                                                    </span>
                                                </div>
                                            </div>
                                        </div>
                                        <input type="hidden" name="opcio-<?= $opcio->id_opcio ?>" value="<?= $mods[0]->id_mod ?>">
                                        <?php endif; ?>
                                    </div>
                                    <?php if($opcio->hores_opcio): ?>
                                    <div>
                                        <br>
                                        <div class="container-w-2">
                                            <p class="subtitle-cost">Hores Totals</p>
                                            <div class="input-group mb-3">
                                                <span class="input-group-text" id="basic-hores-<?= $opcio->id_opcio ?>">
                                                    <span class="material-icons">schedule</span>
                                                </span>
                                                <input type="text" class="form-control" placeholder="00:00" aria-describedby="basic-hores-<?= $opcio->id_opcio ?>">
                                            </div>
                                        </div>
                                    </div>
                                    <?php endif; ?>
                                    <?php if($opcio->comentaris_opcio): ?>
                                    <div>
                                        <br>
                                        <button type="button" class="btn btn-primary btn-sm btn-toggle-icon btn-comment-box" data-box="#comment-box-<?= $opcio->id_opcio ?>">
                                            <span class="material-icons">edit</span> Afegir Comentari
                                        </button>
                                        <div class="mb-3" style="display:none"  id="comment-box-<?= $opcio->id_opcio ?>">
                                            <br>
                                            <!--<label for="option-diseny-txt" class="form-label">Comentaris</label>-->
                                            <textarea class="form-control" rows="3" name="comentarisOpcio[<?= $x ?>][<?= $opcio->id_opcio ?>]" placeholder="Escriu el teu comentari..."></textarea>
                                        </div>
                                    </div>
                                    <?php endif; ?>
                                </div>
                                <?php if($opcio->tipus_opcio == 1): ?>
                                <input type="hidden" name="opcions[]" value="<?= $opcio->id_opcio ?>">
                                <?php else: ?>
                                <input type="hidden" name="opcionsUnica[]" value="<?= $opcio->id_opcio ?>">
                                <?php endif; ?>
                            </div>
                            <?php $x++; endforeach; ?>
                            <?php if($opcio->pagines_seccio): ?>
                            <div class="section-option">
                                <h3 class="title-cost">Pàgines</h3>
                                <p class="subtitle-cost">
                                    Selecciona el nombre de pàgines
                                </p>
                                <div class="options-c">
                                    <div class="options-radio-inline">
                                        <div class="range-c">
                                            <div class="row">
                                                <div class="col-10">
                                                    <input type="range" class="form-range form-range-input" id="range-c-input" min="1" max="100" step="1" value="1" name="pagines" data-item="#range-c-input-val">
                                                </div>
                                                <div class="col-2">
                                                    <span>
                                                        <b><span id="range-c-input-val">1</span> Pàgines</b>
                                                    </span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <br>
                                    <button type="button" class="btn btn-primary btn-sm btn-toggle-icon btn-comment-box" data-box="#comment-box-pagines">
                                        <span class="material-icons">edit</span> Afegir Comentari
                                    </button>
                                    <div class="mb-3 txt-diseny" style="display:none" id="comment-box-pagines">
                                        <br>
                                        <!--<label for="option-diseny-txt" class="form-label">Comentaris</label>-->
                                        <textarea class="form-control" id="option-web-txt" name="comentarisPagines" rows="3" placeholder="Escriu el teu comentari..."></textarea>
                                    </div>
                                </div>
                            </div>
                            <?php endif; ?>
                            <?php if($seccio[0]->comentaris_seccio): ?>
                            <br>
                            <button type="button" class="btn btn-primary btn-sm btn-toggle-icon btn-comment-box" data-box="#comment-box-comentaris">
                                <span class="material-icons">edit</span> Afegir Comentari
                            </button>
                            <div class="mb-3 txt-diseny" style="display:none" id="comment-box-comentaris">
                                <br>
                                <!--<label for="option-diseny-txt" class="form-label">Comentaris</label>-->
                                <textarea class="form-control" id="option-web-txt" name="comentarisComentaris" rows="3" placeholder="Escriu el teu comentari..."></textarea>
                            </div>
                            <?php endif; ?>
                            <?php if($opcio->manteniment_seccio): ?>
                            <div class="section-option">
                                <h3 class="title-cost">Manteniment</h3>
                                <p class="subtitle-cost">
                                    Un cop finalitzat el projecte, es recomana contractar el servei de manteniment. Aquest servei garantitzara un seguiment i actualitzacions constants del lloc. El sistema utilitzat son les bosses d’hores. El client podrà utilitzar la bossa d’hores sense caducitat i en qualsevol departament de Grafix.
                                </p>
                                <ul class="subtitle-cost list-opts">
                                    <li>
                                        <span class="material-icons">radio_button_checked</span> Pack de 10h (440€ + iva).
                                    </li>
                                    <li>
                                        <span class="material-icons">radio_button_checked</span> Pack de 20h. (840€ + iva).
                                    </li>
                                    <li>
                                        <span class="material-icons">radio_button_checked</span> Pack 40h. (1600€ + iva).
                                    </li>
                                    <li>
                                        <span class="material-icons">radio_button_checked</span> A la carta. (a valorar)
                                    </li>
                                </ul>
                                <div class="options-c">
                                    <div class="options-radio-inline">
                                        <div class="row row-cols-3">
                                            <div class="col">
                                                <div class="form-check form-radio-option">
                                                    <label class="form-check-label form-check-manteniment">
                                                        <div class="title-option title-option-single">
                                                            <span>Si vull Manteniment</span>
                                                            <input type="radio" name="manteniment" value="1" checked>
                                                        </div>
                                                    </label>
                                                </div>
                                            </div>
                                            <div class="col">
                                                <div class="form-check form-radio-option">
                                                    <label class="form-check-label">
                                                        <div class="title-option title-option-single">
                                                            <span>No vull Manteniment</span>
                                                            <input type="radio" name="manteniment" value="0">
                                                        </div>
                                                    </label>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <br>
                                    <button type="button" class="btn btn-primary btn-sm btn-toggle-icon btn-comment-box" data-box="#comment-box-manteniment">
                                        <span class="material-icons">edit</span> Afegir Comentari
                                    </button>
                                    <div class="mb-3 txt-diseny" style="display:none" id="comment-box-manteniment">
                                        <br>
                                        <!--<label for="option-diseny-txt" class="form-label">Comentaris</label>-->
                                        <textarea class="form-control" id="option-web-txt" rows="3" placeholder="Escriu el teu comentari..."></textarea>
                                    </div>
                                </div>
                            </div>
                            <?php endif; ?>
                            <div class="section-option section-option-last">
                                <div class="options-c text-center">
                                    <input type="hidden" name="seccioId" value="<?= $seccioId ?>">
                                    <input type="hidden" id="total" name="total">
                                    <button type="submit" class="btn btn-primary btn-lg btn-step"><span class="material-icons">navigate_next</span> SEGÜENT</button>
                                    <!--<router-link to="/preu-final" class="btn btn-primary btn-lg btn-step">
                                        <span class="material-icons">navigate_next</span> SEGÜENT
                                    </router-link>-->
                                </div>
                            </div>
                        </form>
                    </div>
                    <div class="text-center">
                        <a href="<?= base_url() ?>" class="btn btn-light btn-sm"><span class="material-icons" style="position: relative;top: 3px;font-size: 15px;">arrow_back</span> Tornar enrere</a>
                    </div>
                </div>
                <div class="col-md-4">
                    <?= $this->include('partials/estimationBox')?>
                </div>
            </div>
        </div>
    </div>

<script>

<?= $this->endSection() ?>